/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclic.block;

import com.lothrazar.cyclic.block.BlockCyclic;
import com.lothrazar.cyclic.util.EntityUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class LaunchBlock
extends BlockCyclic {
    private static final float ANGLE = 90.0f;
    protected static final VoxelShape PRESSED_AABB = Block.m_49796_((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)0.5, (double)15.0);
    boolean sneakPlayerAvoid = true;
    boolean doRedstone;

    public LaunchBlock(BlockBehaviour.Properties properties, boolean doRedstone) {
        super(properties.m_60910_().m_60978_(0.5f));
        this.doRedstone = doRedstone;
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        return PRESSED_AABB;
    }

    public boolean canConnectRedstone(BlockState state, BlockGetter world, BlockPos pos, Direction side) {
        return false;
    }

    public boolean m_7898_(BlockState state, LevelReader worldIn, BlockPos pos) {
        BlockPos blockpos = pos.m_7495_();
        return LaunchBlock.m_49936_((BlockGetter)worldIn, (BlockPos)blockpos) || LaunchBlock.m_49863_((LevelReader)worldIn, (BlockPos)blockpos, (Direction)Direction.UP);
    }

    public void m_7892_(BlockState state, Level worldIn, BlockPos pos, Entity entity) {
        if (this.sneakPlayerAvoid && entity instanceof Player && ((Player)entity).m_6047_()) {
            return;
        }
        if (worldIn.f_46443_) {
            EntityUtil.launch(entity, 90.0f, this.getPower(worldIn, pos));
        } else if (entity instanceof Player) {
            // empty if block
        }
    }

    private float getPower(Level world, BlockPos pos) {
        if (!this.doRedstone) {
            return 1.6f;
        }
        int power = 0;
        for (Direction direction : Direction.values()) {
            int localPow;
            if (direction == Direction.UP || (localPow = world.m_46681_(pos.m_142300_(direction), direction)) <= power) continue;
            power = localPow;
        }
        float ratio = (float)(power + 2) / 16.0f;
        return 2.4f * ratio;
    }
}

